#include <amxmodx>
#include <umitem>
#include <engine>
#include <fun>

new PLUGIN_NAME[] 	= "UM Item: Super Pump"
new PLUGIN_AUTHOR[] 	= "Cheap_Suit"
new PLUGIN_VERSION[] 	= "1.0"

#define SHOTGUN_AIMING 	32
#define MAX_KB_DISTANCE	900
#define SHOTGUN_PUSH	580.0

new fire 
new g_OldAmmo[33]
new g_LastWeapon[33]
new bool:g_SuperPump[33]

public plugin_init() 
{
	register_plugin(PLUGIN_NAME, PLUGIN_VERSION, PLUGIN_AUTHOR)
	register_item("Super Pump", "Explosive M3 shotgun", 4000)
	register_event("CurWeapon","Event_CurWeapon", "be", "1=1")
}

public plugin_precache() {
	fire = precache_model("sprites/mushroom.spr")
}

public client_connect(id) {
	g_SuperPump[id] = false
}

public Enable_Item(id) {
	g_SuperPump[id] = true
}

public Disable_Item(id) {
	g_SuperPump[id] = false
} 

public Event_CurWeapon(id)
{
	if(!is_user_connected(id) || !is_user_alive(id)) {
		return PLUGIN_CONTINUE
	}
	
	if(!g_SuperPump[id]) {
		return PLUGIN_CONTINUE
	}
	
	new Weapon_Id = read_data(2)
	new Weapon_Clip = read_data(3)
	
	if(Weapon_Id == CSW_M3) 
	{
		if(g_OldAmmo[id] > Weapon_Clip && Weapon_Clip >= 0) 
		{
			if(g_LastWeapon[id] != Weapon_Id) 
			{
				g_LastWeapon[id] = Weapon_Id
				return PLUGIN_CONTINUE
			}
			
			new iVec1[3], iVec2[3], iVec3[3]
			get_user_origin(id, iVec1, 1)
			get_user_origin(id, iVec2, 4)
			get_user_origin(id, iVec3, 3)
			
			draw_tracers(iVec1, iVec2)
		
			iVec2[0] += SHOTGUN_AIMING
			draw_tracers(iVec1, iVec2)
			    
			iVec2[1] += SHOTGUN_AIMING
			draw_tracers(iVec1, iVec2)
			    
			iVec2[2] += SHOTGUN_AIMING
			draw_tracers(iVec1, iVec2)
			 
			iVec2[0] -= SHOTGUN_AIMING
			iVec2[0] -= SHOTGUN_AIMING
			draw_tracers(iVec1, iVec2)
			
			iVec2[1] -= SHOTGUN_AIMING
			iVec2[1] -= SHOTGUN_AIMING
			draw_tracers(iVec1, iVec2)
			
			iVec2[2] -= SHOTGUN_AIMING
			iVec2[2] -= SHOTGUN_AIMING
			draw_tracers(iVec1, iVec2)
			
			create_explosion(iVec3)
		
			new Players[32], iNum
			get_players(Players, iNum, "a")
			
			for(new i = 0; i < iNum; ++i)
			{
				new target = Players[i]
				new tOrigin[3]
				get_user_origin(target, tOrigin)
				if(get_distance(iVec3, tOrigin) <= MAX_KB_DISTANCE)
				{	
					new Float:flOrigin[3]
					new Friendlyfire = get_cvar_num("mp_friendlyfire")
					switch(Friendlyfire)
					{
						case 0:
						{
							new ateam = get_user_team(id)
							new bteam = get_user_team(target)
							if(ateam != bteam)
							{
								IVecFVec(iVec3, flOrigin)
								set_velocity_from_origin(target, flOrigin, SHOTGUN_PUSH)
							}
						}
						case 1:
						{
							IVecFVec(iVec3, flOrigin)
							set_velocity_from_origin(target, flOrigin, SHOTGUN_PUSH)
						}
					}
				}
			}
		}
		g_OldAmmo[id] = Weapon_Clip
		g_LastWeapon[id] = Weapon_Id
	}
	return PLUGIN_CONTINUE
}

draw_tracers(vec1[3], vec2[3]) 
{
	message_begin(MSG_PAS, SVC_TEMPENTITY, vec1)
	write_byte(6)
	write_coord(vec1[0])
	write_coord(vec1[1])
	write_coord(vec1[2])
	write_coord(vec2[0])
	write_coord(vec2[1])
	write_coord(vec2[2])
	message_end()
}

create_explosion(Origin[3])
{
	message_begin(MSG_ALL, SVC_TEMPENTITY) 
	write_byte(3)
	write_coord(Origin[0]) 
	write_coord(Origin[1]) 
	write_coord(Origin[2] + 22) 
	write_short(fire)	 
	write_byte(10)			
	write_byte(12)			
	write_byte(0)			
	message_end()
	
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
	write_byte(116)
	write_coord(Origin[0]) 
	write_coord(Origin[1]) 
	write_coord(Origin[2]) 
	write_byte(47)
	message_end()
}

get_velocity_from_origin(ent, Float:fOrigin[3], Float:fSpeed, Float:fVelocity[3])
{
	new Float:fEntOrigin[3]
	entity_get_vector(ent, EV_VEC_origin, fEntOrigin)
    
	new Float:fDistance[3]
	fDistance[0] = fEntOrigin[0] - fOrigin[0]
	fDistance[1] = fEntOrigin[1] - fOrigin[1]
	fDistance[2] = fEntOrigin[2] - fOrigin[2]

	new Float:fTime = (vector_distance(fEntOrigin,fOrigin ) / fSpeed)

	fVelocity[0] = fDistance[0] / fTime
	fVelocity[1] = fDistance[1] / fTime
	fVelocity[2] = fDistance[2] / fTime
    
	return(fVelocity[0] && fVelocity[1] && fVelocity[2])
}

set_velocity_from_origin(ent, Float:fOrigin[3], Float:fSpeed)
{
	new Float:fVelocity[3]
	get_velocity_from_origin( ent, fOrigin, fSpeed, fVelocity )

	entity_set_vector( ent, EV_VEC_velocity, fVelocity )

	return(1)
} 
